#ifndef LINT
static char SCCSid[] = "@(#)GMZSr.c 19.1 01/13/06 Copyright (c) 1991-1996 Varian Assoc.,Inc. All Rights Reserved";
#endif
/* 
 * Varian Assoc.,Inc. All Rights Reserved.
 * This software contains proprietary and confidential
 * information of Varian Assoc., Inc. and its contributors.
 * Use, disclosure and reproduction is prohibited without
 * prior consent.
 */

/* GMZSnew - simple Zangger-Sterk pure shift with hard 180 before soft */


#include <standard.h>
#include <Pbox_psg.h>

pulsesequence()
{
   double          p1lvl,
   	droppts = getval("droppts"),		/* number of dummy points to acquire */
	gzlvl1=getval("gzlvl1"),		/* CTP selection gradient */
	gzlvl2=getval("gzlvl2"),		/* slice select gradient */
	gzlvl_ss=getval("gzlvl_ss"),		/* steady-state crusher gradient */
    	gtss=getval("gtss"),			/* steady-state gradient pulse width */
	gt1=getval("gt1"),			/* CTP gradient pulse width */
    	gstab=getval("gstab"),			/* gradient stabilisation delay */
	selpw=getval("selpw"),		/* pulse length for the soft 180  */
	selpwr=getval("selpwr");	/* power level  for the soft 180  */

char 	sspul[MAXSTR],
     	selshape[MAXSTR];		/* pulse file for the soft 180 */

getstr("sspul",sspul);
getstr("selshape",selshape);

/*Check that gstab > 1/sw */
  if (gstab<(droppts)/sw)
   {
      abort_message("gstab should be greater than droppts/sw\n");
   }

/*Check that sw1 is an integer submultiple of sw */
  if (fabs((sw/sw1)-(double)((int)((sw/sw1)+0.5)))> 0.01) 
   {
      text_message("WARNING: sw1 should be an integer submultiple of sw\n");
   }
/*Check that power deposition in gradient coil is not excessive*/
  if ( (gzlvl2*gzlvl2*selpw/(gradstepsz*gradstepsz))> 0.01) /* maximum 1% of full dissipation */
   {
      abort_message("Slice select gradient gzlvl2 is dangerously high\n");
   }



/* LOAD AND INITIALIZE VARIABLES */
   getstr("sspul", sspul);

/* CHECK CONDITIONS */

/* CALCULATE PHASES */
mod4(ct,v1);
mod2(ct,v3);
sub(v3,one,v2);
add(v3,one,v4);
add(v4,one,v5);
mod4(v2,v2);
mod4(v3,v3);
mod4(v4,v4);
hlv(ct,v6);
hlv(v6,v7);
hlv(v7,v7);
mod4(v6,v6);
mod4(v7,v7);
add(v6,v7,oph);
dbl(oph,oph);
add(oph,v1,oph);
mod4(oph,oph);  /* v1 + 2(v6+v7) */

/* BEGIN ACTUAL PULSE SEQUENCE CODE */
   status(A);
      if (sspul[0] == 'y')
      {
                 zgradpulse(gzlvl_ss,gtss);
                 obspower(tpwr);
         rgpulse(1000*1e-6, zero, rof1, 0.0e-6);
         rgpulse(1000*1e-6, one, 0.0e-6, rof1);
                 zgradpulse(gzlvl_ss,gtss*0.6);
      }
      	obspower(tpwr);
      	hsdelay(d1);
   	status(B);

   	rgpulse(pw,v1,rof1,rof2);	

	delay(d2/2.0);
	
	delay((0.25/sw1)-gt1-gstab);			
	zgradpulse(gzlvl1*0.5,gt1);		
	delay(gstab);			
   	rgpulse(pw*2,v7,rof1,rof2);				/* Hard 180*/
	delay(0.25/sw1);			
	delay(gstab);
	zgradpulse(-gzlvl1*0.5,gt1);				/* second CTP pulse*/
	delay(gstab);
	obspower(selpwr);				/* POWER CHANGE (SOFT) */
	rgradient('z',gzlvl2);					/* SLICE selection*/
	shaped_pulse(selshape,selpw, v6, rof1, rof2);	   	/* SLICE selection - Soft 180 */
	rgradient('z',0.0);					/* SLICE selection*/
	delay(gstab);
	zgradpulse(-gzlvl1,gt1);				/* third CTP pulse*/
      rcvron();
      obsblank();
	delay(gstab-droppts/sw);
	obspower(tpwr);						/* Power level change (HARD) */
	delay(d2/2.0);

/* detection */
   status(C);
}


